<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Promo;
use App\Models\Kategori;
use App\Models\Layanan;
use Illuminate\Support\Str;

class PromoController extends Controller
{
    public function create()
    {
        $data['kategoris'] = Kategori::get();
        $data['data'] = Promo::orderBy('id', 'asc')->get();
        return view('components.admin.promo', $data);
    }

    public function store(Request $request)
    {
        $request->validate([
            'thumbnail' => 'required|image|mimes:jpg,png,webp,jpeg',
            'nama' => 'required',
            'kategori_id' => 'required',
            'layanan_id' => 'required',
            'harga_promo' => 'required'
        ]);
        
        $img = $request->file('thumbnail');
        $filename = Str::random('15') . '.' . $img->extension();
        $img->move('assets/promo', $filename);
        
        Layanan::where('id', $request->layanan_id)->update([
            'harga_flashsale' => $request->harga_promo,
            'status_flashsale' => 'Yes',
            'expired_flash_sale' => $request->expired_flash_sale
        ]);
        $kode = Kategori::where('id', $request->kategori_id)->select('kode')->first();
        
        $promo = new Promo();
        $promo->nama = $request->nama;
        $promo->url = $kode->kode;
        $promo->id_kategori = $request->kategori_id;
        $promo->id_layanan = $request->layanan_id;
        $promo->harga_promo = $request->harga_promo;
        $promo->thumbnail = "/assets/promo/".$filename;
        $promo->save();

        return back()->with('success', 'Berhasil menambahkan Flashsale');
    }

    public function delete($id)
    {
        try{
            $data = Promo::where('id', $id)->select('thumbnail','id_layanan')->first();
            unlink(public_path($data->thumbnail));
            Layanan::where('id', $data->id_layanan)->update([
                'harga_flashsale' => null,
                'status_flashsale' => 'No',
                'expired_flash_sale' => null
            ]);
            Promo::where('id', $id)->delete();
            return back()->with('success', 'Berhasil hapus!');
        }catch(\Exception $e){
            $data = Promo::where('id', $id)->select('thumbnail','id_layanan')->first();
            Promo::where('id', $id)->delete();
            Layanan::where('id', $data->id_layanan)->update([
                'harga_flashsale' => null,
                'status_flashsale' => 'No',
                'expired_flash_sale' => null
            ]);
            return back()->with('success', 'Berhasil hapus!');
        }
    }

public function detail($id)
    {
        $data = Promo::where('id', $id)->first();
        
        $send = "
                <form action='".route("promo.detail.update", [$id])."' method='POST' enctype='multipart/form-data'>
                    <input type='hidden' name='_token' value='".csrf_token()."'>
                    <div class='mb-3 row'>
                        <label class='col-lg-2 col-form-label' for='example-fileinput'>Nama Flashsale</label>
                        <div class='col-lg-10'>
                            <input type='text' class='form-control' value='".$data->nama. "' name='nama'>
                        </div>
                    </div>
                    <div class='mb-3 row'>
                        <label class='col-lg-2 col-form-label' for='example-fileinput'>Harga Flashsale</label>
                        <div class='col-lg-10'>
                            <input type='text' class='form-control' value='" . $data->harga_promo. "' name='harga_promo'>
                        </div>
                    </div>
                    <div class='mb-3 row'>
                        <label class='col-lg-2 col-form-label' for='example-fileinput'>Expired Flashsale</label>
                        <div class='col-lg-10'>
                            <input type='date' class='form-control' value='" . $data->expired_flash_sale. "' name='expired_flash_sale'>
                        </div>
                    </div>
                    <div class='mb-3 row'>
                        <label class='col-lg-2 col-form-label' for='example-fileinput'>Thumbnail</label>
                        <div class='col-lg-10'>
                            <input type='file' class='form-control' value='" . $data->thumbnail. "' name='thumbnail'>
                        </div>
                    </div>
                    <div class='modal-footer'>
                        <button type='button' class='btn btn-danger' data-bs-dismiss='modal'>Close</button>
                        <button type='submit' class='btn btn-primary'>Simpan</button>
                    </div>
                </form>
        ";

        return $send;        
    }  
    
    public function patch(Request $request, $id)
    {
        if($request->file('thumbnail')){
            $file = $request->file('thumbnail');
            $folder = 'assets/promo';
            $file->move($folder, $file->getClientOriginalName());      
            Promo::where('id', $id)->update([
                'thumbnail' => "/".$folder."/".$file->getClientOriginalName()
            ]);
        }
        
        $data = Promo::where('id', $id)->first();
        Layanan::where('id', $data->layanan_id)->update([
            'harga_flashsale' => $request->harga_promo,
            'status_flashsale' => 'Yes',
            'expired_flash_sale' => $request->expired_flash_sale
        ]);
        
        $promo = Promo::where('id', $id)->update([
            'nama' => $request->nama,
            'harga_promo' => $request->harga_promo
        ]);
           
        return back()->with('success', 'Berhasil update Flashsale');        
    }        
}
